/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.system.Settings;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class Color {
    private static HashMap<String, org.eclipse.swt.graphics.Color> colorCache = new HashMap();
    public static final Color WIDGET_BG = new Color(null, new RGB(255, 255, 255));
    public static final Color WIDGET_FG = new Color(null, new RGB(0, 0, 0));
    public static final Color BACKGROUND = new Color(null, GUI.getDisplay().getSystemColor(22).getRGB());
    public static final Color FOREGROUND = new Color(null, GUI.getDisplay().getSystemColor(21).getRGB());
    public static final Color WHITE = new Color(null, GUI.getDisplay().getSystemColor(1).getRGB());
    public static final Color BLACK = new Color(null, GUI.getDisplay().getSystemColor(2).getRGB());
    public static final Color BORDER = new Color("color.border", new RGB(0, 0, 0));
    public static final Color COMMENT = new Color("color.comment", Color.getMiddle(BACKGROUND, FOREGROUND));
    public static final Color ERROR = new Color("color.error", new RGB(250, 10, 10));
    public static final Color SUCCESS = new Color("color.success", new RGB(0, 130, 32));
    public static final Color LINK = new Color("color.link", new RGB(0, 0, 100));
    public static final Color LINK_ACTIVE = new Color("color.link.active", new RGB(0, 0, 200));
    public static final Color MANDATORY_BG = new Color("color.mandatory.bg", new RGB(255, 240, 220));
    public static final Color TOOLTIP_BG = new Color("color.tooltip.bg", new RGB(239, 230, 159));
    private String name;
    private RGB value;
    private RGB defaultValue;
    private static Settings settings = new Settings(Color.class);

    private static RGB getMiddle(Color c1, Color c2) {
        RGB r1 = c1.getSWTColor().getRGB();
        RGB r2 = c2.getSWTColor().getRGB();
        return new RGB(Color.middle(r1.red, r2.red), Color.middle(r1.green, r2.green), Color.middle(r1.blue, r2.blue));
    }

    private static int middle(int i1, int i2) {
        return (i1 + i2) / 2;
    }

    public Color(String name, RGB defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public final org.eclipse.swt.graphics.Color getSWTColor() {
        org.eclipse.swt.graphics.Color c;
        if (this.value == null) {
            RGB rGB = this.value = this.name != null ? settings.getRGB(this.name, this.defaultValue) : this.defaultValue;
        }
        if ((c = colorCache.get(this.value.toString())) != null && !c.isDisposed()) {
            return c;
        }
        c = new org.eclipse.swt.graphics.Color((Device)GUI.getDisplay(), this.value);
        colorCache.put(this.value.toString(), c);
        return c;
    }

    public final void setSWTColor(org.eclipse.swt.graphics.Color newColor) {
        if (newColor == null || newColor.isDisposed()) {
            return;
        }
        this.value = newColor.getRGB();
        if (this.name != null) {
            settings.setAttribute(this.name, this.value);
        }
        colorCache.remove(this.value.toString());
    }

    public final void reset() {
        this.value = this.defaultValue;
        if (this.name != null) {
            settings.setAttribute(this.name, this.value);
        }
        colorCache.remove(this.value.toString());
    }
}

